﻿using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Framework.Web.UI
{
    /// <summary>
    /// ローカライズ機能を持ったテーブル
    /// </summary>
    public class LTable : System.Web.UI.WebControls.Table, ILocalizeControl
    {
        /// <summary>
        /// キャプションのローカライズキー
        /// </summary>
        [Category("Custom")]
        [DefaultValue("")]
        public string CaptionLTextKey { get; set; }


        #region ILocalizeControl メンバ

        public void Localize(System.Globalization.CultureInfo lang)
        {
            if (this.CaptionLTextKey.IsNotEmpty())
            {
                base.Caption = LTextMgr.GetText(lang, this.CaptionLTextKey);
            }
        }

        #endregion
    }
}
